#include <stdlib.h>

#include "karmadb.h"

int main(int argc, char **argv)
{
	karma_db_t *db;
	int fid;
	char *s1, *s2, *s3;
	int s4;
	FILE *fp;

	if (argc < 3)
	{
		fprintf(stderr, "Usage: %s <smalldb> <fid>\n", argv[0]);
		exit(1);
	}

	fp = fopen(argv[1], "rb");
	if (!fp)
	{
		perror("open");
		exit(1);
	}

	fid = strtol(argv[2], NULL, 0);

	db = kdb_read(fp);
	karma_entry_t entry = kdb_find_entry(db, fid); 
	if (!entry)
	{
		printf("No such record\n");
		kdb_free(db);
		exit(1);
	}

	kdb_get_attribute(db, entry, "title", &s1);
	kdb_get_attribute(db, entry, "artist", &s2);
	kdb_get_attribute(db, entry, "source", &s3);
	kdb_get_attribute(db, entry, "duration", &s4);

	printf("Song is %s by %s on album %s (%d:%02d.%03d)\n", s1, s2, s3, 
		s4 / 60000, (s4 / 1000) % 60, s4 % 1000);

	kdb_free(db);
}

