#ifndef _KARMA_DB_H
#define _KARMA_DB_H

#include <stdio.h>
#include <glib.h>

// all known attributes
#define K_FID		"fid"
#define K_OFFSET	"offset"
#define K_TRAILER	"trailer"
#define K_DURATION	"duration"
#define K_LENGTH	"length"
#define K_SAMPLERATE	"samplerate"
#define K_CTIME		"ctime"
#define K_OPTIONS	"options"
#define K_BPM		"bpm"
#define K_RMS		"rms"
#define K_STDDEV	"stddev"
#define K_NORMALISATION	"normalisation"
#define K_PLAY_LAST	"play_last"
#define K_PLAY_COUNT_LIMIT	"play_count_limit"
#define K_PLAY_COUNT	"play_count"
#define K_TRACKNR	"tracknr"
#define K_FILE_ID	"file_id"
#define K_MARKED	"marked"
#define K_PLAYLIST	"playlist"
#define K_PROFILE	"profile"
#define K_TYPE		"type"
#define K_CODEC		"codec"
#define K_ARTIST	"artist"
#define K_SOURCE	"source"
#define K_TITLE		"title"
#define K_BITRATE	"bitrate"
#define K_GENRE		"genre"
#define K_YEAR		"year"
#define K_RID		"rid"
#define K_FID_GENERATION	"fid_generation"
#define K_PROFILER_VERSION	"profiler_version"
#define K_REPLAY_GAIN_PEAK	"replay_gain_peak"
#define K_REPLAY_GAIN_RADIO	"replay_gain_radio"
#define K_REPLAY_GAIN_AUDIOPHILE	"replay_gain_audiophile"
#define K_BYTES_SILENCE_SOF	"bytes_silence_sof"
#define K_BYTES_SILENCE_EOF	"bytes_silence_eof"

struct k_str_info {
	char *str;
	int offset;
};

typedef enum k_atype
{
	K_TYPE_LE32,
	K_TYPE_STRING,
	K_TYPE_BLOB,
	K_TYPE_CHAR,
	K_TYPE_LE16
} k_atype_t;

typedef struct k_attrib
{
	char *name;
	char *table;
	int table_len;
	k_atype_t type;
	int dunno;
} k_attrib_t;

typedef struct karma_db
{
	int version;
	int ctime;
	int eight;
	int three;
	int num_attribs;
	k_attrib_t *attribs;
	int num_objects;
	GList *objects;			/* a list of arrays of pointers */ 
	GHashTable *name_hash;		/* converts attrib name to index */
	int dmap_size;
	unsigned char *dmap;            /* bitmap of deleted files */
} karma_db_t;

typedef int karma_entry_t;              /* opaque entry object */

karma_db_t *kdb_read(FILE *fp);
int kdb_get_max_fid(karma_db_t *db);
void kdb_free(karma_db_t *db);

#endif
