#include <stdio.h>
#include <stdlib.h>
#include "hexdump.h"

static int isprint(int c)
{
	return (c >= ' ' && c <= '~');
}

void hexdump(unsigned char *buf, int size, int is_out, int offset)
{
    char *out = malloc((size+15)/16 * 80);
    *out = 0;
    int i, j;
    for (i = 0; i < size ; i += 16)
    {
        sprintf(out, "%s%c %04lx    ", out, is_out ? '>' : '<', i + offset);
        for (j=0; j < 16; j++)
        {
            if (j+i < size)
                sprintf(out, "%s%02x ", out, buf[j]);
            else
                sprintf(out, "%s   ", out);
        }

        for (j = 0; j<16 && j+i < size; j++)
        {
            char c = buf[j];
            if (!isprint(c)) c = '.';
            sprintf(out, "%s%c", out, c);
        }
        buf += 16;
        sprintf(out, "%s\n",out);
    }
    printf("%s\n", out);
    free(out);
}
